/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.client;

import com.ibm.hsc.client.PIDataBeanInterface;
import com.ibm.hsc.client.PIVirtualSCSIAdapterDataBean;
import com.ibm.hsc.client.PIVirtualSlotDataBean;
import com.ibm.hsc.common.util.CSVRecord;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class PIVirtualSCSIDataBean
extends PIVirtualSlotDataBean
implements PIDataBeanInterface {
    public static final String KEY_DEVICE_ATTRIBUTES = "adapter_type";
    public static final String KEY_BACKING_DEVICES = "backing_devices";
    public static final String KEY_SERVER_PARTITION_ID = "remote_lpar_id";
    public static final String KEY_SERVER_PARTITION_NAME = "remote_lpar_name";
    public static final String KEY_SERVER_SLOT_NUMBER = "remote_slot_num";
    public static final short CLIENT = 0;
    public static final short SERVER = 1;
    public static final String STRING_CLIENT = "client";
    public static final String STRING_NONE = "none";
    public static final String STRING_SERVER = "server";
    public static final int ANY_REMOTE_SLOT_LPAR = 65535;
    public static final String STRING_ANY_REMOTE_SLOT_LPAR = "any";
    public static final UnsignedInt16 DEFAULT_SERVER_PARTITION_ID = new UnsignedInt16(65535);
    public static final UnsignedInt16 DEFAULT_SERVER_SLOT_NUMBER = new UnsignedInt16(65535);
    public static final short MIN_SLOT_NUMBER = 2;
    public static final short MIN_SERVER_SLOT_NUMBER = 2;
    public static final String[] ALL_KEYS = new String[]{"lpar_name", "lpar_id", "slot_num", "state", "adapter_type", "remote_lpar_id", "remote_lpar_name", "remote_slot_num", "is_required", "backing_devices"};
    private UnsignedInt8 m_deviceAttributes;
    private UnsignedInt16 m_serverPartitionID;
    private UnsignedInt16 m_serverSlotNumber;
    private Vector m_backingDevices;
    public String m_serverPartitionName;

    public String[] getAllKeys() {
        return ALL_KEYS;
    }

    public PIVirtualSCSIDataBean() {
        this.m_configurationState = new UnsignedInt8(2);
    }

    public UnsignedInt8 getDeviceAttributes() {
        return this.m_deviceAttributes;
    }

    public UnsignedInt16 getServerPartitionID() {
        return this.m_serverPartitionID;
    }

    public String getServerPartitionName() {
        return this.m_serverPartitionName;
    }

    public UnsignedInt16 getServerSlotNumber() {
        return this.m_serverSlotNumber;
    }

    public Vector getBackinDevices() {
        return this.m_backingDevices;
    }

    public void setDeviceAttributes(UnsignedInt8 unsignedInt8) {
        this.m_deviceAttributes = unsignedInt8;
    }

    public void setServerPartitionID(UnsignedInt16 unsignedInt16) {
        this.m_serverPartitionID = unsignedInt16;
    }

    public void setServerPartitionName(String string) {
        this.m_serverPartitionName = string;
    }

    public void setServerSlotNumber(UnsignedInt16 unsignedInt16) {
        this.m_serverSlotNumber = unsignedInt16;
    }

    public void setBackingDevices(Vector vector) {
        this.m_backingDevices = vector;
    }

    public String toString(String[] stringArray, boolean bl, String string) {
        CSVRecord cSVRecord = new CSVRecord(true, string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if ("lpar_id".equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_partitionID, bl);
                continue;
            }
            if ("lpar_name".equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_partitionName, bl);
                continue;
            }
            if ("slot_num".equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_slotNumber, bl);
                continue;
            }
            if ("config".equals(string2)) {
                CSVRecord.append(cSVRecord, string2, "scsi", bl);
                continue;
            }
            if ("state".equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_runtimeState, bl);
                continue;
            }
            if ("drc_name".equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_drcName, bl);
                continue;
            }
            if (KEY_DEVICE_ATTRIBUTES.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.getDeviceAttrString(), bl);
                continue;
            }
            if (KEY_SERVER_PARTITION_ID.equals(string2)) {
                if (this.m_serverPartitionID == null || this.m_serverPartitionID.intValue() != 65535) {
                    CSVRecord.append(cSVRecord, string2, (Number)this.m_serverPartitionID, bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, STRING_ANY_REMOTE_SLOT_LPAR, bl);
                continue;
            }
            if (KEY_SERVER_PARTITION_NAME.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_serverPartitionName, bl);
                continue;
            }
            if (KEY_SERVER_SLOT_NUMBER.equals(string2)) {
                if (this.m_serverSlotNumber == null || this.m_serverSlotNumber.intValue() != 65535) {
                    CSVRecord.append(cSVRecord, string2, (Number)this.m_serverSlotNumber, bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, STRING_ANY_REMOTE_SLOT_LPAR, bl);
                continue;
            }
            if ("is_required".equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.getIsRequiredString(), bl);
                continue;
            }
            if (!KEY_BACKING_DEVICES.equals(string2)) continue;
            if (this.m_backingDevices != null && this.m_backingDevices.size() != 0) {
                CSVRecord cSVRecord2 = new CSVRecord(true, ",");
                for (int j = 0; j < this.m_backingDevices.size(); ++j) {
                    PIVirtualSCSIAdapterDataBean pIVirtualSCSIAdapterDataBean = (PIVirtualSCSIAdapterDataBean)this.m_backingDevices.get(j);
                    cSVRecord2.add(pIVirtualSCSIAdapterDataBean.toStringForProf());
                }
                CSVRecord.append(cSVRecord, string2, cSVRecord2.toString(), bl);
                continue;
            }
            CSVRecord.append(cSVRecord, string2, STRING_NONE, bl);
        }
        return cSVRecord.toString();
    }

    public String toString() {
        return "[" + this.toString(ALL_KEYS, true, ",") + "]";
    }

    private String getDeviceAttrString() {
        if (this.m_deviceAttributes.shortValue() == 0) {
            return STRING_CLIENT;
        }
        return STRING_SERVER;
    }

    public String toStringForProf() {
        CSVRecord cSVRecord = new CSVRecord(true, "/");
        cSVRecord.add(this.m_slotNumber);
        cSVRecord.add(this.getDeviceAttrString());
        if (this.m_serverPartitionID != null) {
            if (this.m_serverPartitionID.intValue() == 65535) {
                cSVRecord.add(STRING_ANY_REMOTE_SLOT_LPAR);
            } else {
                cSVRecord.add(this.m_serverPartitionID);
            }
        } else {
            cSVRecord.add("");
        }
        if (this.m_serverPartitionName != null) {
            cSVRecord.add(this.m_serverPartitionName);
        } else {
            cSVRecord.add("");
        }
        if (this.m_serverSlotNumber != null) {
            if (this.m_serverSlotNumber.intValue() == 65535) {
                cSVRecord.add(STRING_ANY_REMOTE_SLOT_LPAR);
            } else {
                cSVRecord.add(this.m_serverSlotNumber);
            }
        } else {
            cSVRecord.add("");
        }
        cSVRecord.add(this.getIsRequiredString());
        return cSVRecord.toString();
    }
}

